Ext.data.JsonP.sol_common_SordProvider({"tagname":"class","name":"sol.common.SordProvider","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.SordProvider.js","href":"lib_sol.common.SordProvider.html#sol-common-SordProvider"}],"author":[{"tagname":"author","name":"ESt, ELO Digital Office GmbH","email":null}],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"filter","tagname":"cfg","owner":"sol.common.SordProvider","id":"cfg-filter","meta":{}},{"name":"id","tagname":"cfg","owner":"sol.common.SordProvider","id":"cfg-id","meta":{}},{"name":"ids","tagname":"cfg","owner":"sol.common.SordProvider","id":"cfg-ids","meta":{}},{"name":"masks","tagname":"cfg","owner":"sol.common.SordProvider","id":"cfg-masks","meta":{}},{"name":"optimize","tagname":"cfg","owner":"sol.common.SordProvider","id":"cfg-optimize","meta":{}},{"name":"options","tagname":"cfg","owner":"sol.common.SordProvider","id":"cfg-options","meta":{}},{"name":"output","tagname":"cfg","owner":"sol.common.SordProvider","id":"cfg-output","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"search","tagname":"cfg","owner":"sol.common.SordProvider","id":"cfg-search","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"BASICSORDKEYS","tagname":"property","owner":"sol.common.SordProvider","id":"property-BASICSORDKEYS","meta":{"private":true}},{"name":"BLANK_VALUES","tagname":"property","owner":"sol.common.SordProvider","id":"property-BLANK_VALUES","meta":{"private":true}},{"name":"ESCAPE_VALUES","tagname":"property","owner":"sol.common.SordProvider","id":"property-ESCAPE_VALUES","meta":{"private":true}},{"name":"MBS","tagname":"property","owner":"sol.common.SordProvider","id":"property-MBS","meta":{"private":true}},{"name":"SORDACCESSORS","tagname":"property","owner":"sol.common.SordProvider","id":"property-SORDACCESSORS","meta":{"private":true}},{"name":"defaultMaxGroups","tagname":"property","owner":"sol.common.SordProvider","id":"property-defaultMaxGroups","meta":{}},{"name":"defaultMaxResults","tagname":"property","owner":"sol.common.SordProvider","id":"property-defaultMaxResults","meta":{}},{"name":"fallbackIdProp","tagname":"property","owner":"sol.common.SordProvider","id":"property-fallbackIdProp","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"manualOptimizationCache","tagname":"property","owner":"sol.common.SordProvider","id":"property-manualOptimizationCache","meta":{"private":true}},{"name":"maskObjKeyCache","tagname":"property","owner":"sol.common.SordProvider","id":"property-maskObjKeyCache","meta":{"private":true}},{"name":"pageSizeMax","tagname":"property","owner":"sol.common.SordProvider","id":"property-pageSizeMax","meta":{}},{"name":"searchCache","tagname":"property","owner":"sol.common.SordProvider","id":"property-searchCache","meta":{"private":true}},{"name":"wildCard","tagname":"property","owner":"sol.common.SordProvider","id":"property-wildCard","meta":{}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addAsDirectValueInstruction","tagname":"method","owner":"sol.common.SordProvider","id":"method-addAsDirectValueInstruction","meta":{"private":true}},{"name":"addAsSourceTargetInstruction","tagname":"method","owner":"sol.common.SordProvider","id":"method-addAsSourceTargetInstruction","meta":{"private":true}},{"name":"addConverterKey","tagname":"method","owner":"sol.common.SordProvider","id":"method-addConverterKey","meta":{"private":true}},{"name":"addCriterionToQuery","tagname":"method","owner":"sol.common.SordProvider","id":"method-addCriterionToQuery","meta":{"private":true}},{"name":"addDataCollectedFromIdContainer","tagname":"method","owner":"sol.common.SordProvider","id":"method-addDataCollectedFromIdContainer","meta":{"private":true}},{"name":"addDirectValuesToIds","tagname":"method","owner":"sol.common.SordProvider","id":"method-addDirectValuesToIds","meta":{"private":true}},{"name":"addDirectValuesToSords","tagname":"method","owner":"sol.common.SordProvider","id":"method-addDirectValuesToSords","meta":{"private":true}},{"name":"addFilterDefinition","tagname":"method","owner":"sol.common.SordProvider","id":"method-addFilterDefinition","meta":{"private":true}},{"name":"addInstructionsToCache","tagname":"method","owner":"sol.common.SordProvider","id":"method-addInstructionsToCache","meta":{"private":true}},{"name":"addMb","tagname":"method","owner":"sol.common.SordProvider","id":"method-addMb","meta":{"private":true}},{"name":"addOR","tagname":"method","owner":"sol.common.SordProvider","id":"method-addOR","meta":{"private":true}},{"name":"addOutputInstruction","tagname":"method","owner":"sol.common.SordProvider","id":"method-addOutputInstruction","meta":{"private":true}},{"name":"addToOptimizationCache","tagname":"method","owner":"sol.common.SordProvider","id":"method-addToOptimizationCache","meta":{"private":true}},{"name":"arrayToRegExp","tagname":"method","owner":"sol.common.SordProvider","id":"method-arrayToRegExp","meta":{"private":true}},{"name":"assignFallbackIdProp","tagname":"method","owner":"sol.common.SordProvider","id":"method-assignFallbackIdProp","meta":{"private":true}},{"name":"buildFindByIndex","tagname":"method","owner":"sol.common.SordProvider","id":"method-buildFindByIndex","meta":{"private":true}},{"name":"buildFindDirect","tagname":"method","owner":"sol.common.SordProvider","id":"method-buildFindDirect","meta":{"private":true}},{"name":"buildFindInfoForContextTerms","tagname":"method","owner":"sol.common.SordProvider","id":"method-buildFindInfoForContextTerms","meta":{"private":true}},{"name":"buildFindInfoForFindByIndex","tagname":"method","owner":"sol.common.SordProvider","id":"method-buildFindInfoForFindByIndex","meta":{"private":true}},{"name":"buildFindInfoForFindDirect","tagname":"method","owner":"sol.common.SordProvider","id":"method-buildFindInfoForFindDirect","meta":{"private":true}},{"name":"buildIdContainer","tagname":"method","owner":"sol.common.SordProvider","id":"method-buildIdContainer","meta":{"private":true}},{"name":"buildMasksQuery","tagname":"method","owner":"sol.common.SordProvider","id":"method-buildMasksQuery","meta":{"private":true}},{"name":"buildQuery","tagname":"method","owner":"sol.common.SordProvider","id":"method-buildQuery","meta":{"private":true}},{"name":"buildRegEx","tagname":"method","owner":"sol.common.SordProvider","id":"method-buildRegEx","meta":{"private":true}},{"name":"buildValueQuery","tagname":"method","owner":"sol.common.SordProvider","id":"method-buildValueQuery","meta":{"private":true}},{"name":"calcFlags","tagname":"method","owner":"sol.common.SordProvider","id":"method-calcFlags","meta":{"private":true}},{"name":"castThenAddResults","tagname":"method","owner":"sol.common.SordProvider","id":"method-castThenAddResults","meta":{"private":true}},{"name":"cleanConfig","tagname":"method","owner":"sol.common.SordProvider","id":"method-cleanConfig","meta":{"private":true}},{"name":"closeFind","tagname":"method","owner":"sol.common.SordProvider","id":"method-closeFind","meta":{"private":true}},{"name":"collectDataFromId","tagname":"method","owner":"sol.common.SordProvider","id":"method-collectDataFromId","meta":{"private":true}},{"name":"contains","tagname":"method","owner":"sol.common.SordProvider","id":"method-contains","meta":{"private":true}},{"name":"createObjKey","tagname":"method","owner":"sol.common.SordProvider","id":"method-createObjKey","meta":{"private":true}},{"name":"createObjKeys","tagname":"method","owner":"sol.common.SordProvider","id":"method-createObjKeys","meta":{"private":true}},{"name":"createSordZ","tagname":"method","owner":"sol.common.SordProvider","id":"method-createSordZ","meta":{"private":true}},{"name":"defaultDataCollection","tagname":"method","owner":"sol.common.SordProvider","id":"method-defaultDataCollection","meta":{"private":true}},{"name":"definesDirectValue","tagname":"method","owner":"sol.common.SordProvider","id":"method-definesDirectValue","meta":{"private":true}},{"name":"escapeOrRemoveInvalidCharacters","tagname":"method","owner":"sol.common.SordProvider","id":"method-escapeOrRemoveInvalidCharacters","meta":{"private":true}},{"name":"extendQueryByCustomQuery","tagname":"method","owner":"sol.common.SordProvider","id":"method-extendQueryByCustomQuery","meta":{"private":true}},{"name":"extendQueryByWildCard","tagname":"method","owner":"sol.common.SordProvider","id":"method-extendQueryByWildCard","meta":{"private":true}},{"name":"fastFilter","tagname":"method","owner":"sol.common.SordProvider","id":"method-fastFilter","meta":{"private":true}},{"name":"filterSords","tagname":"method","owner":"sol.common.SordProvider","id":"method-filterSords","meta":{"private":true}},{"name":"finalizeCollector","tagname":"method","owner":"sol.common.SordProvider","id":"method-finalizeCollector","meta":{"private":true}},{"name":"find","tagname":"method","owner":"sol.common.SordProvider","id":"method-find","meta":{"private":true}},{"name":"findAll","tagname":"method","owner":"sol.common.SordProvider","id":"method-findAll","meta":{"private":true}},{"name":"findIds","tagname":"method","owner":"sol.common.SordProvider","id":"method-findIds","meta":{"private":true}},{"name":"formBlobsExtractor","tagname":"method","owner":"sol.common.SordProvider","id":"method-formBlobsExtractor","meta":{"private":true}},{"name":"formatSord","tagname":"method","owner":"sol.common.SordProvider","id":"method-formatSord","meta":{"private":true}},{"name":"formatSordAsTemplateSord","tagname":"method","owner":"sol.common.SordProvider","id":"method-formatSordAsTemplateSord","meta":{"private":true}},{"name":"formatterIsRequired","tagname":"method","owner":"sol.common.SordProvider","id":"method-formatterIsRequired","meta":{"private":true}},{"name":"generateInstructions","tagname":"method","owner":"sol.common.SordProvider","id":"method-generateInstructions","meta":{"private":true}},{"name":"generateMbsFromOptions","tagname":"method","owner":"sol.common.SordProvider","id":"method-generateMbsFromOptions","meta":{"private":true}},{"name":"generateObjKeyLineMapping","tagname":"method","owner":"sol.common.SordProvider","id":"method-generateObjKeyLineMapping","meta":{"private":true}},{"name":"getAvailableTerms","tagname":"method","owner":"sol.common.SordProvider","id":"method-getAvailableTerms","meta":{"private":true}},{"name":"getCachedInstructions","tagname":"method","owner":"sol.common.SordProvider","id":"method-getCachedInstructions","meta":{"private":true}},{"name":"getContextTerms","tagname":"method","owner":"sol.common.SordProvider","id":"method-getContextTerms","meta":{"private":true}},{"name":"getCriterionQuery","tagname":"method","owner":"sol.common.SordProvider","id":"method-getCriterionQuery","meta":{"private":true}},{"name":"getFindInfoBuilder","tagname":"method","owner":"sol.common.SordProvider","id":"method-getFindInfoBuilder","meta":{"private":true}},{"name":"getFindInfoForConstantSearchValues","tagname":"method","owner":"sol.common.SordProvider","id":"method-getFindInfoForConstantSearchValues","meta":{"private":true}},{"name":"getFromOptimizationCache","tagname":"method","owner":"sol.common.SordProvider","id":"method-getFromOptimizationCache","meta":{"private":true}},{"name":"getFromSearchCache","tagname":"method","owner":"sol.common.SordProvider","id":"method-getFromSearchCache","meta":{"private":true}},{"name":"getGroupingTerm","tagname":"method","owner":"sol.common.SordProvider","id":"method-getGroupingTerm","meta":{"private":true}},{"name":"getIdsOfIds","tagname":"method","owner":"sol.common.SordProvider","id":"method-getIdsOfIds","meta":{"private":true}},{"name":"getInstructionsFromCache","tagname":"method","owner":"sol.common.SordProvider","id":"method-getInstructionsFromCache","meta":{"private":true}},{"name":"getSearchCriteriaQuery","tagname":"method","owner":"sol.common.SordProvider","id":"method-getSearchCriteriaQuery","meta":{"private":true}},{"name":"getSord","tagname":"method","owner":"sol.common.SordProvider","id":"method-getSord","meta":{"private":true}},{"name":"idsOf","tagname":"method","owner":"sol.common.SordProvider","id":"method-idsOf","meta":{"private":true}},{"name":"impureConcat","tagname":"method","owner":"sol.common.SordProvider","id":"method-impureConcat","meta":{"private":true}},{"name":"initSearchAndProcessingInstructions","tagname":"method","owner":"sol.common.SordProvider","id":"method-initSearchAndProcessingInstructions","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"initializeCaching","tagname":"method","owner":"sol.common.SordProvider","id":"method-initializeCaching","meta":{"private":true}},{"name":"isValidSourceDefinition","tagname":"method","owner":"sol.common.SordProvider","id":"method-isValidSourceDefinition","meta":{"private":true}},{"name":"maintainSearchInfo","tagname":"method","owner":"sol.common.SordProvider","id":"method-maintainSearchInfo","meta":{"private":true}},{"name":"mapExtractor","tagname":"method","owner":"sol.common.SordProvider","id":"method-mapExtractor","meta":{"private":true}},{"name":"mapKeysExtractor","tagname":"method","owner":"sol.common.SordProvider","id":"method-mapKeysExtractor","meta":{"private":true}},{"name":"objKeysExtractor","tagname":"method","owner":"sol.common.SordProvider","id":"method-objKeysExtractor","meta":{"private":true}},{"name":"optimizationIdDefined","tagname":"method","owner":"sol.common.SordProvider","id":"method-optimizationIdDefined","meta":{"private":true}},{"name":"optimizeObjectAccessors","tagname":"method","owner":"sol.common.SordProvider","id":"method-optimizeObjectAccessors","meta":{"private":true}},{"name":"pageFind","tagname":"method","owner":"sol.common.SordProvider","id":"method-pageFind","meta":{"private":true}},{"name":"pagingIdDefined","tagname":"method","owner":"sol.common.SordProvider","id":"method-pagingIdDefined","meta":{"private":true}},{"name":"parens","tagname":"method","owner":"sol.common.SordProvider","id":"method-parens","meta":{"private":true}},{"name":"parseOutputDefinition","tagname":"method","owner":"sol.common.SordProvider","id":"method-parseOutputDefinition","meta":{"private":true}},{"name":"parseSearchValue","tagname":"method","owner":"sol.common.SordProvider","id":"method-parseSearchValue","meta":{"private":true}},{"name":"performSearch","tagname":"method","owner":"sol.common.SordProvider","id":"method-performSearch","meta":{"private":true}},{"name":"prepareMask","tagname":"method","owner":"sol.common.SordProvider","id":"method-prepareMask","meta":{"private":true}},{"name":"prepareSearchInfo","tagname":"method","owner":"sol.common.SordProvider","id":"method-prepareSearchInfo","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.SordProvider","id":"method-process","meta":{}},{"name":"processIdContainer","tagname":"method","owner":"sol.common.SordProvider","id":"method-processIdContainer","meta":{"private":true}},{"name":"processIds","tagname":"method","owner":"sol.common.SordProvider","id":"method-processIds","meta":{"private":true}},{"name":"processResult","tagname":"method","owner":"sol.common.SordProvider","id":"method-processResult","meta":{"private":true}},{"name":"propsToArrays","tagname":"method","owner":"sol.common.SordProvider","id":"method-propsToArrays","meta":{"private":true}},{"name":"reinitializeFormatterSettingsIfRequired","tagname":"method","owner":"sol.common.SordProvider","id":"method-reinitializeFormatterSettingsIfRequired","meta":{"private":true}},{"name":"removeEmptyFields","tagname":"method","owner":"sol.common.SordProvider","id":"method-removeEmptyFields","meta":{"private":true}},{"name":"sanitizeQueryValue","tagname":"method","owner":"sol.common.SordProvider","id":"method-sanitizeQueryValue","meta":{"private":true}},{"name":"searchFor","tagname":"method","owner":"sol.common.SordProvider","id":"method-searchFor","meta":{"private":true}},{"name":"searchViaContextTerms","tagname":"method","owner":"sol.common.SordProvider","id":"method-searchViaContextTerms","meta":{"private":true}},{"name":"searchViaIndex","tagname":"method","owner":"sol.common.SordProvider","id":"method-searchViaIndex","meta":{"private":true}},{"name":"setUnchangedIdsAsResult","tagname":"method","owner":"sol.common.SordProvider","id":"method-setUnchangedIdsAsResult","meta":{"private":true}},{"name":"sordKeysExtractor","tagname":"method","owner":"sol.common.SordProvider","id":"method-sordKeysExtractor","meta":{"private":true}},{"name":"stringToRegExp","tagname":"method","owner":"sol.common.SordProvider","id":"method-stringToRegExp","meta":{"private":true}},{"name":"templateSordFilter","tagname":"method","owner":"sol.common.SordProvider","id":"method-templateSordFilter","meta":{"private":true}},{"name":"updateSearchCache","tagname":"method","owner":"sol.common.SordProvider","id":"method-updateSearchCache","meta":{"private":true}},{"name":"valuesWithoutWildcard","tagname":"method","owner":"sol.common.SordProvider","id":"method-valuesWithoutWildcard","meta":{"private":true}},{"name":"RF_sol_common_service_SordProvider","tagname":"method","owner":"sol.common.SordProvider","id":"static-method-RF_sol_common_service_SordProvider","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.SordProvider","short_doc":"Retrieves sords using a search (findByIndex) or by predefined ids and formats the retrieved sords according to\nthe ou...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.SordProvider</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider' target='_blank'>lib_sol.common.SordProvider.js</a></div></pre><div class='doc-contents'><p>Retrieves sords using a search (findByIndex) or by predefined ids and formats the retrieved sords according to\nthe output parameter. If fuzzy search (getContextTerms) is used, the output parameter is ignored since this\nsearch variant returns value groups just like an SQL GROUP BY query.</p>\n\n<p>This service is optimized by analyzing defined search terms and output options to retrieve the results in the\nfastest way possible. Additionally, this service caches a subset of analyzed parameters on demand to further\nimprove execution time.</p>\n\n<h3>Searching</h3>\n\n<p>Two search variants are provided. findByIndex and getContextTerms</p>\n\n<h4>Search Definition</h4>\n\n<p>Both search variants use the same search definition. This makes it easier to switch between variants if needed.\nFindByIndex is used as a default.</p>\n\n<p>A search definition contains a <code>masks</code> property and a <code>search</code> property, which in turn contains additional search criteria.</p>\n\n<p>The masks property is an Array of Strings, where each string must define a mask to include in the search.</p>\n\n<pre><code>masks: [\"My Mask\", \"My Mask 2\"]\n</code></pre>\n\n<p>The search <code>property</code> can contain search criteria.</p>\n\n<pre><code>search: [\n  { key: \"SOL_TYPE\", value: \"RECRUITING_CANDIDATE\" },\n  { key: \"DEPARTMENTS\", value: [\"Sales\", \"Purchasing\"] },\n  { key: \"ACTIVITYSTATUS\", value: \"A - *\"}\n]\n</code></pre>\n\n<p>You must also define an output definition. (see further below)</p>\n\n<h4>Fuzzy Search (getContextTerms)</h4>\n\n<p>Fuzzy search can be used if the results need to be grouped.\nFuzzy means, the result is not guaranteed to reflect the current state of the ELO sql database.\nFuzzy search and therefore getContextTerms queries iSearch which uses another higher performance\ndatabase containing possibly out of date values. (Re-indexing takes place about every minute)</p>\n\n<p>If you need 100% valid results you must not use fuzzy search. If speed matters most and you only need\nan estimated grouped result, you may use fuzzy search.</p>\n\n<p>Example for a fuzzy search grouped by field/property \"a\"</p>\n\n<pre><code>results before grouping:\n  [{ a: \"test\", b: \"rest\" }, { a: \"now\", b: \"test\" }, { \"a: test\", c: \"what\" }]\nresults after grouping:\n  {test: 2, now: 1}\n</code></pre>\n\n<p>Note: when using fuzzy search, you only have access to the <code>results after grouping</code>.</p>\n\n<p>To activate fuzzy search, define</p>\n\n<pre><code>options: {\n  fuzzy: { groupBy: { type: \"GRP\", key: MY_GROUPING_FIELD  } } // only GRP supported for now\n}\n</code></pre>\n\n<p>You can limit the number of returned groups by defining</p>\n\n<pre><code>options: {\n  fuzzy: { groupBy: { type: \"GRP\", key: MY_GROUPING_FIELD  }, maxGroups: 20 }\n}\n</code></pre>\n\n<h5>Case Sensitivity</h5>\n\n<p>To turn off case sensitivity, define <code>ignoreCase: true</code> in the search definition for the respective field:</p>\n\n<pre><code>search: [\n  { key: \"SUBJECT\", value: \"Progress\", \"ignoreCase\": true },\n  { key: \"DEPARTMENTS\", value: [\"Sales\", \"Purchasing\"] }\n]\n</code></pre>\n\n<p>would return e.g.</p>\n\n<pre><code>{Progress: 2, PROGRESS: 5, progreSs: 1}\n</code></pre>\n\n<h4>FindDirect search</h4>\n\n<p>To use findDirect as the search mode (will additionally search in memos, fulltext,...), pass</p>\n\n<pre><code>options: {\n  findDirect: true\n}\n</code></pre>\n\n<p>If you need to define a custom query term, pass</p>\n\n<pre><code>options: {\n  query: \"your term\"\n}\n</code></pre>\n\n<p>If a query is passed, you don't have to pass <code>findDirect: true</code> also.</p>\n\n<h4>Tokenization (findDirect only)</h4>\n\n<p>To search in the tokenized elastic search field, define <code>tokenized: true</code> in the search definition for the respective field:</p>\n\n<pre><code>search: [\n  { key: \"SUBJECT\", value: \"Progress\", \"tokenized\": true },\n  { key: \"DEPARTMENTS\", value: [\"Sales\", \"Purchasing\"] }\n]\n</code></pre>\n\n<h4>Paged Searching</h4>\n\n<p>If you know there will be lots of results, it may make sense to use a paged search.</p>\n\n<p>To activate paging, define</p>\n\n<pre><code>options: { paging: true }\n</code></pre>\n\n<p>The service result will then contain an additional property <code>searchId</code>, which is a unique search id.</p>\n\n<pre><code>{\n  searchId: \"(141DD-12QW-46GS-9928JJ)\",\n  moreResults: true,\n  sords: [...]\n}\n</code></pre>\n\n<p>If you want to fetch the next batch of results, call the service again by replacing the <code>paging: true</code> with <code>searchId</code> and the received id:</p>\n\n<pre><code>{\n  options: { searchId: \"(141DD-12QW-46GS-9928JJ)\" }\n}\n</code></pre>\n\n<p>The last batch of results will neither contain a search id nor the moreResults property.</p>\n\n<h5>Controlling paging</h5>\n\n<p>Define the following, to retrieve 10 search results starting from the 131st result.</p>\n\n<pre><code>{\n  options: { searchId: \"(141DD-12QW-46GS-9928JJ)\", startPagingFrom: 130, pageSize: 10 }\n}\n</code></pre>\n\n<p>You can define any integer greater than -1 as startPagingFrom.\nWhen there are no more results, instead of throwing an exception, an empty result.sords array will be returned.</p>\n\n<h3>Page sizes</h3>\n\n<p>You can define how many results should be delivered per batch by defining a <code>pageSize</code></p>\n\n<pre><code>{\n  options: { pageSize: 100 }\n}\n</code></pre>\n\n<p>Page sizes greater than 1000 are not allowed and will automatically be reduced to 1000.</p>\n\n<p>To end a paged search/close a search, pass</p>\n\n<pre><code>{\n  options: { searchId: \"(141DD-12QW-46GS-9928JJ)\", endPaging: true }\n}\n</code></pre>\n\n<p>This will return <code>{ sords: [] }</code>.</p>\n\n<p>If you try to fetch results for a searchId which has been closed, an exception will be thrown.</p>\n\n<h3>Formatting</h3>\n\n<p>Search results will be processed by a formatter. The formatter options must be provided in the <code>output</code> parameter.</p>\n\n<pre><code>output: [\n  { source: { type: \"SORD\", \"key\": \"guid\" }, target: { prop: \"id\" } },\n  { source: { type: \"MAP\", \"key\": \"MY_MAP_FIELD\" }, target: { prop: \"myprop\" } }\n]\n</code></pre>\n\n<p>If 3 sords were found during search, these formatter options would result in</p>\n\n<pre><code>{\n  sords: [\n    { id: \"(345AD-DFS22-2FSF3-121WD)\", myprop: \"Testvalue\" },\n    { id: \"(3573D-DF6522-2FAVF3-1SDD)\", myprop: \"Another value\" }\n    { id: \"(3J5AD-DFQQ2-2FSFY-12G)\", myprop: \"Result 3\" }\n  ]\n}\n</code></pre>\n\n<h4>Wildcards for retrieving an unknown amount of MAP/BLOB fields having prefix x</h4>\n\n<p>You can include MAP-fields in the output using a wildcard. This can be handy if you don't\nknow how many MAP-fields with a specific prefix will exist in the sord.</p>\n\n<pre><code>output: [\n  { source: { type: \"MAP\", \"key\": \"LOCALE_*\" }, target: { prop: \"*\" } }\n]\n</code></pre>\n\n<p>Hint: <code>prop</code> will be ignored, you can define whatever you like. However, to make clear what you want to do, please define <code>\"*\"</code> or similar.</p>\n\n<p>This would output e.g.:</p>\n\n<pre><code>{\n  sords: [\n    { LOCALE_APPLE: \"sol.lang.apple\", LOCALE_NEW: \"sol.lang.new\" },\n    { LOCALE_APPLE: \"sol.lang.apple\", LOCALE_NEW: \"sol.lang.new\", LOCALE_TREE: \"sol.lang.tree\" },\n  ]\n}\n</code></pre>\n\n<h4>Format as TemplateSord</h4>\n\n<p>Define the parameter</p>\n\n<pre><code>{\n  options: { formatAsTemplateSord: true }\n}\n</code></pre>\n\n<p>When this parameter is defined, the <code>target.prop</code> name is ignored by default. A template sord based on the original fieldnames will be created.</p>\n\n<p>To use the name defined in <code>target.prop</code>, define</p>\n\n<pre><code>{\n  options: { formatAsTemplateSord: true, ignorePropertyNames: false }\n}\n</code></pre>\n\n<h4>Adding properties with custom values</h4>\n\n<p>You may want to add a fixed property to every result. This is possible by only defining a target.</p>\n\n<pre><code>output: [\n  { target: { prop: \"myspecialprop\", value: \"My Fixed Value\" } }\n]\n</code></pre>\n\n<h3>Skipping search and providing ids directly</h3>\n\n<p>If you only want to use the formatting facilities of this service, you can omit the search definition and\njust provide objIds/guids directly. The service will automatically determine, whether you passed guids or objIds.</p>\n\n<pre><code>ids: [\"12345\", \"43241\"]\n</code></pre>\n\n<p>ObjIds and guids can't be mixed.</p>\n\n<h3>Filtering results</h3>\n\n<p>When you perform a normal search, results will already be filtered by the search criteria. However, you may also want to filter e.g. based on\na search result's MAP field. This is made possible by the <code>filter</code> parameter.</p>\n\n<p>Also, if you pass guids or objIds instead of searching, you would always receive all of the formatted sords, no matter, which criteria they have.\nThe same filter mechanism can be applied to this use-case.</p>\n\n<p>Only properties which are defined as a <code>target.prop</code> in the <code>output</code>-definition can be filtered.</p>\n\n<p>If a sord matches the filter, it will be kept. If it does not match the filter, it will be removed from the result-set.</p>\n\n<p>Just like the output-parameter, if using an optimized search, the parsed filter will be cached. This also means, that you can omit it\non consecutive calls since it will be ignored anyways.\n(This can be done e.g. by adding it to the array parameter of the ixUtils.optimizedExecute function.)</p>\n\n<h4>Applying a filter</h4>\n\n<pre><code>filter: [\n  { prop: \"soltype\", value: \"RECRUIT*_*\" },\n  { prop: \"status\", value: [\"A -*\", \"B -*\", \"C -*\"] }\n]\n</code></pre>\n\n<p>This example would only return sords having a soltype property value of \"RECRUIT\" + Any characters + \"_\" + Any characters\nwhile also having one of the status values beginning with \"A -\" or \"B -\" or \"C -\".</p>\n\n<h4>Applying a filter in TemplateSord mode</h4>\n\n<p>If <code>formatAsTemplateSord: true</code> is passed as an option, you need to define the whole property path to apply a filter.</p>\n\n<pre><code>filter: [\n  { prop: \"objKeys.soltype\", value: \"RECRUIT*_*\" },\n  { prop: \"mapKeys.status\", value: [\"A -*\", \"B -*\", \"C -*\"] }\n]\n</code></pre>\n\n<h4>Excluding a field only used for filtering from the sord-result</h4>\n\n<p>If you include a field in the output-definition, just to enable its usage in the filter, you might not want to include\nthe respective field in the end-result. Just add the <code>exclude:true</code> property to the desired definition.</p>\n\n<pre><code>filter: [\n  { prop: \"soltype\", value: \"RECRUIT*_*\", \"exclude\": true },\n  { prop: \"status\", value: [\"A -*\", \"B -*\", \"C -*\"] }\n]\n</code></pre>\n\n<p>Hint: excluding a field will not work in TemplateSord mode.</p>\n\n<h3>Options</h3>\n\n<h4>Returning sparse results</h4>\n\n<p>Returns only properties which have a value. Empty strings are not a value.</p>\n\n<p>This can further reduce network bandwith if defined.</p>\n\n<pre><code>options: { sparse: true }\n</code></pre>\n\n<p>Hint: Caused by implementation details of the indexserver api, map and formblob values are not included\nin the result sord in the first place, even if <code>sparse</code> is undefined or false.</p>\n\n<h4>Allowing searches without a mask</h4>\n\n<p>For security reasons, the <code>search</code> must always contain a mask. (Read: Must not contain an empty string as mask)</p>\n\n<pre><code>// Not allowed:\n1. masks: []\n2. masks: [\"\"]\n3. masks: [\"test\", \"\"]\n</code></pre>\n\n<p>You may accidentally define the third variant, which would produce duplicate results.</p>\n\n<p>To allow the second variant or just omit the masks parameter completely, alltogether</p>\n\n<pre><code>options: { allowEmptyMask: true }\n</code></pre>\n\n<p>Tip: If a single mask is defined, the search will be fastest. If you define multiple masks or no masks, the formatter will have\nto lookup the mask for every sord.</p>\n\n<h4>Limit Search Results</h4>\n\n<p>You know there are 100000 results in the archive, but you only want 300.</p>\n\n<pre><code>options: { maxResults: 300 }\n</code></pre>\n\n<p><code>maxResults</code> defaults to 5000.</p>\n\n<h3>Optimization</h3>\n\n<p>To further improve the service's performance, you can make it reuse the parsed formatter definitions.</p>\n\n<p>Attention: This should only be used, when it is guaranteed, that the output-parameters stay the same for\nevery call of the service when using the same optimization id.</p>\n\n<p>Note: Optimization can not be used with fuzzy mode. (Since there is no output parameter to cache)</p>\n\n<p>To activate optimization, define</p>\n\n<pre><code>{\n  optimize: true\n}\n</code></pre>\n\n<p>The service result will then contain an additional property <code>optimization</code>, which is a unique optimization cache Id.</p>\n\n<pre><code>{\n  optimization: 59921231,\n  sords: [...]\n}\n</code></pre>\n\n<p>When you call the service the next time, you can omit the output parameter and replace the <code>true</code> of <code>optimize</code> by the id.</p>\n\n<pre><code>{\n  optimize: 59921231\n}\n</code></pre>\n\n<p>This will speed up the function call by some milliseconds. When searching 1000 results, this may not be a big factor,\nbut when only fetching some ids, it will not make much of a difference if you handcode the whole process or just\nuse this function.</p>\n\n<h4>Implementing optimization in a calling class</h4>\n\n<p>This is a recommendation on how to keep track of the optimization ids in your own class.</p>\n\n<p>Set up a class member</p>\n\n<pre><code>_optimizations: {}  // this will be your local cache for storing the optimization ids\n</code></pre>\n\n<p>You can now call <a href=\"#!/api/sol.common.IxUtils-method-optimizedExecute\" rel=\"sol.common.IxUtils-method-optimizedExecute\" class=\"docClass\">sol.common.IxUtils.optimizedExecute</a> whenever you need it.</p>\n\n<pre><code>process: function () {\n  var me = this, candidates, apples;\n  candidates = <a href=\"#!/api/sol.common.IxUtils-method-optimizedExecute\" rel=\"sol.common.IxUtils-method-optimizedExecute\" class=\"docClass\">sol.common.IxUtils.optimizedExecute</a>(\"RF_sol_common_service_SordProvider\", me.myConfigForSearchingCandidates, me._optimizations, \"candids\", [\"output\"]);\n  apples = <a href=\"#!/api/sol.common.IxUtils-method-optimizedExecute\" rel=\"sol.common.IxUtils-method-optimizedExecute\" class=\"docClass\">sol.common.IxUtils.optimizedExecute</a>(\"RF_sol_common_service_SordProvider\", me.myConfigForSearchingApples, me._optimizations, \"appls\", [\"output\"]);\n  return [candidates, apples];\n}\n</code></pre>\n\n<p>The optimizedExecute function can be used with any function implementing the same behaviour as SordProvider (taking\nan <code>optimize</code> parameter {Boolean|String}, returning an <code>optimization</code> {String})</p>\n\n<p>The first parameter takes the RF to execute, the second parameter are the arguments passed to the RF (usually an Object).</p>\n\n<p>The third parameter defines that we would like to use _optimizations as our optimization id cache.</p>\n\n<p>The fourth parameter enables calling the function in an optimized way for different configs.</p>\n\n<p>The fifth parameter defines which config-properties should not be transfered to the RF when an optimization is available. E.g. SordProvider does not need the output\nparameter because it caches the instructions generated from this parameter.</p>\n\n<p>You can make up any name for an optimization. However, it should be unique in your class\nsince the name decides on which optimization id will be passed to the RF.</p>\n\n<h3>Examples</h3>\n\n<h4>Give an objId, get a guid</h4>\n\n<pre><code>Call\n{ ids: [\"12345\"], output: [{ source: { type: \"SORD\", key: \"guid\" } }] }\nResult\n{ sords: [\"(345AD-DFS22-2FSF3-121WD)\"] }\n</code></pre>\n\n<h4>Search without mask, return a single result</h4>\n\n<pre><code>Call\n{\n  masks: [\"\"],\n  search: [\n    { key: \"SOL_TYPE\", value: [\"RECRUITING_REQUISITION\", \"RECRUITING_POOL\"] }\n    { key: \"RECRUITING_REQUISITION_NO\", value: \"0001\" }\n  ],\n  output: [\n    { source: { type: \"SORD\" , key: \"guid\" }, target: { prop: \"guid\" } },\n    { source: { type: \"GRP\" , key: \"RECRUITING_REQUISITION_NAME\" }, target: { prop: \"name\" } }\n  ],\n  options: {\n    allowEmptyMask: true,\n    maxResults: 1\n  }\n}\nResult\n{ sords: [{ guid: \"(2A15C78E-866E-D9FE-0A44-832AFFAF85EE)\", name: \"IT Engineer\" }] }\n</code></pre>\n\n<h4>Search with multiple masks and paging, return 80 results in batches of 50</h4>\n\n<p>There is one \"Recruiting Requisition\" in the archive and more than 79 \"Recruiting Candidate\"s</p>\n\n<pre><code>Call 1\n{\n  masks: [\"Recruiting Requisition\", \"Recruiting Candidate\"],\n  search: [{ key: \"RECRUITING_REQUISITION_NO\", value: \"0001\" }],\n  output: [\n    { source: { type: \"SORD\" , key: \"guid\" }, target: { prop: \"guid\" } },\n    { source: { type: \"SORD\" , key: \"name\" }, target: { prop: \"name\" } }\n  ],\n  options: {\n    paging: true,\n    pageSize: 50\n  }\n}\nResult 1\n{\n  sords: [\n    { guid: \"(BEDCE611-7B78-9C48-E9D9-8DFE7A2ABAB3)\", name: \"Senior IT Engineer (0001)\" },\n    { guid: \"(5C9A204C-D16C-4EC8-C5AF-5933ECA37120)\", name: \"Fesh, Dieter (00234)\" },\n    // 48 more ...\n  ],\n  searchId: \"(5C041998-C430-11D8-04A8-CA1EC9CC2502)\"\n}\n\nCall 2\n{\n  options: {\n    searchId: \"(5C041998-C430-11D8-04A8-CA1EC9CC2502)\",\n    startPagingFrom: 49\n    pageSize: 50\n  }\n}\nResult 2\n{\n  sords: [\n    { guid: \"(B57CBBE6-81D8-75CC-836D-26717DDCF7FC)\", name: \"Monkfish, Thelonious (0005)\" },\n    { guid: \"(1A6E094C-A49E-17A9-19B4-FB56A8FD4E04)\", name: \"Nex, Carl (0001)\" }\n    // 28 more ...\n  ]\n}\n</code></pre>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-filter' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-cfg-filter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-cfg-filter' class='name expandable'>filter</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<ul><li><span class='pre'>Object</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>prop</span> : String<div class='sub-desc'><p>name of the property to read. (property must be defined as a <code>target.prop</code> in the <code>output</code> parameter)</p>\n</div></li><li><span class='pre'>value</span> : String|String[]<div class='sub-desc'><p>filter value. If an array is defined, entries will be concatenated with <code>bitwise OR</code>. The filter is to be understood as working like the array.filter method.</p>\n</div></li></ul></div></li></ul></div></div></div><div id='cfg-id' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-cfg-id' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-cfg-id' class='name expandable'>id</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nA single objId or guid. ...</div><div class='long'><p>(optional)\nA single objId or guid. The sord is fetched, formatted and returned.</p>\n</div></div></div><div id='cfg-ids' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-cfg-ids' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-cfg-ids' class='name expandable'>ids</a> : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nAn Array of objIds or guids. ...</div><div class='long'><p>(optional)\nAn Array of objIds or guids. All sords are fetched, formatted and returned.</p>\n</div></div></div><div id='cfg-masks' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-cfg-masks' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-cfg-masks' class='name expandable'>masks</a> : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nMasks which will be included in the search (OR concatenation). ...</div><div class='long'><p>(optional)\nMasks which will be included in the search (<code>OR</code> concatenation). Define an empty string as array member to include all masks.\nIf all masks are included, the <code>option.allowEmptyMask</code> must be true.</p>\n</div></div></div><div id='cfg-optimize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-cfg-optimize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-cfg-optimize' class='name expandable'>optimize</a> : Boolean|Number<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) if true, caches analyzed parameters. ...</div><div class='long'><p>(optional) if true, caches analyzed parameters. If the <code>optimization</code> value of a result is passed, it will use the cached parameters instead of analyzing again.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-options' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-cfg-options' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-cfg-options' class='name expandable'>options</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<ul><li><span class='pre'>allowEmptyMask</span> : Boolean (optional)<div class='sub-desc'><p>allow <code>masks</code> array to have an empty string as member</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>maxResults</span> : Number (optional)<div class='sub-desc'><p>maximum results for the search. if paging is active, a maximum of 1000 results is returned per paged search. Paged searches ignore this parameter.</p>\n<p>Defaults to: <code>5000</code></p></div></li><li><span class='pre'>paging</span> : Boolean|String (optional)<div class='sub-desc'><p>(optional) if true, searches use paging and return a paging id. If the <code>paging</code> value of a result is passed, the paged search is continued.</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>pageSize</span> : Number (optional)<div class='sub-desc'><p>(optional) if paging is active. this defines how many results will be returned per search</p>\n<p>Defaults to: <code>1000</code></p></div></li><li><span class='pre'>fuzzy</span> : Object<div class='sub-desc'><p>(optional) use getContextTerms instead of findByIndex for searching</p>\n<ul><li><span class='pre'>groupBy</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>type</span> : String|\"GRP\"<div class='sub-desc'><p>only \"GRP\" supported so far.</p>\n</div></li><li><span class='pre'>key</span> : String<div class='sub-desc'><p>name of field to use for grouping</p>\n</div></li></ul></div></li><li><span class='pre'>maxGroups</span> : Number (optional)<div class='sub-desc'><p>(optional) maximum groups to be returned</p>\n<p>Defaults to: <code>25</code></p></div></li></ul></div></li></ul></div></div></div><div id='cfg-output' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-cfg-output' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-cfg-output' class='name expandable'>output</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<ul><li><span class='pre'>Object</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>source</span> : Object<div class='sub-desc'><p>(optional)</p>\n<ul><li><span class='pre'>key</span> : String<div class='sub-desc'><p>name of source field</p>\n</div></li><li><span class='pre'>type</span> : String|\"SORD\"|\"GRP\"|\"MAP\"|\"FORMBLOB\"<div class='sub-desc'><p>type of field</p>\n</div></li></ul></div></li><li><span class='pre'>target</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>prop</span> : String<div class='sub-desc'><p>name of target property</p>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'><p>(optional) value for property (useful if no <code>source</code> defined)</p>\n</div></li></ul></div></li></ul></div></li></ul></div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-search' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-cfg-search' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-cfg-search' class='name expandable'>search</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<ul><li><span class='pre'>Object</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>key</span> : String<div class='sub-desc'><p>name of field</p>\n</div></li><li><span class='pre'>value</span> : String|String[]<div class='sub-desc'><p>search value. If an array is defined, entries will be concatenated with <code>OR</code></p>\n</div></li></ul></div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-BASICSORDKEYS' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-property-BASICSORDKEYS' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-property-BASICSORDKEYS' class='name expandable'>BASICSORDKEYS</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Use specific SordC for these values. ...</div><div class='long'><p>Use specific SordC for these values.</p>\n<p>Defaults to: <code>[&quot;ID&quot;, &quot;GUID&quot;, &quot;NAME&quot;, &quot;DESC&quot;, &quot;MASK&quot;, &quot;XDATEISO&quot;, &quot;IDATEISO&quot;]</code></p></div></div></div><div id='property-BLANK_VALUES' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-property-BLANK_VALUES' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-property-BLANK_VALUES' class='name expandable'>BLANK_VALUES</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>these values will be removed from findDirect search queries ...</div><div class='long'><p>these values will be removed from findDirect search queries</p>\n<p>Defaults to: <code>[&quot;\\\\[&quot;, &quot;\\\\]&quot;, &quot;\\\\{&quot;, &quot;\\\\}&quot;, &quot;=&quot;, &quot;\\\\|&quot;, &quot;\\\\(&quot;, &quot;\\\\)&quot;, &quot;\\\\^&quot;, &quot;\\\\\\&quot;&quot;, &quot;~&quot;, &quot;:&quot;, &quot;\\\\\\\\&quot;, &quot;/&quot;, &quot;&lt;&quot;, &quot;&gt;&quot;, &quot;\\\\+&quot;, &quot;&amp;&quot;, &quot;!&quot;, &quot;\\\\?&quot;]</code></p></div></div></div><div id='property-ESCAPE_VALUES' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-property-ESCAPE_VALUES' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-property-ESCAPE_VALUES' class='name expandable'>ESCAPE_VALUES</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>these values will be escaped in findDirect search queries ...</div><div class='long'><p>these values will be escaped in findDirect search queries</p>\n<p>Defaults to: <code>[&quot;(-)&quot;]</code></p></div></div></div><div id='property-MBS' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-property-MBS' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-property-MBS' class='name expandable'>MBS</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'><p>mb map</p>\n</div><div class='long'><p>mb map</p>\n</div></div></div><div id='property-SORDACCESSORS' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-property-SORDACCESSORS' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-property-SORDACCESSORS' class='name expandable'>SORDACCESSORS</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>used to decide on which property should be read during formatting ...</div><div class='long'><p>used to decide on which property should be read during formatting</p>\n<p>Defaults to: <code>{SORD: &quot;sordKeys&quot;, GRP: &quot;objKeys&quot;, MAP: &quot;mapKeys&quot;, FORMBLOB: &quot;formBlobs&quot;}</code></p></div></div></div><div id='property-defaultMaxGroups' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-property-defaultMaxGroups' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-property-defaultMaxGroups' class='name expandable'>defaultMaxGroups</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Limits how many groups will be returned by a fuzzy search. ...</div><div class='long'><p>Limits how many groups will be returned by a fuzzy search. Overwritten by <code>options.fuzzy.maxGroups</code> if defined by user</p>\n<p>Defaults to: <code>25</code></p></div></div></div><div id='property-defaultMaxResults' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-property-defaultMaxResults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-property-defaultMaxResults' class='name expandable'>defaultMaxResults</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Limits how many results will be returned by a search. ...</div><div class='long'><p>Limits how many results will be returned by a search. Overwritten by <code>options.maxResults</code> if defined by user</p>\n<p>Defaults to: <code>5000</code></p></div></div></div><div id='property-fallbackIdProp' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-property-fallbackIdProp' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-property-fallbackIdProp' class='name expandable'>fallbackIdProp</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>is used as property name, if only ids are returned but direct values are set and no target.prop was defined. ...</div><div class='long'><p>is used as property name, if only ids are returned but direct values are set and no target.prop was defined.</p>\n<p>Defaults to: <code>&quot;id&quot;</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div><div id='property-manualOptimizationCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-property-manualOptimizationCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-property-manualOptimizationCache' class='name expandable'>manualOptimizationCache</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>optimized output definitions ...</div><div class='long'><p>optimized <code>output</code> definitions</p>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='property-maskObjKeyCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-property-maskObjKeyCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-property-maskObjKeyCache' class='name expandable'>maskObjKeyCache</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>mask line mappings for faster access to GRP-field values ...</div><div class='long'><p>mask line mappings for faster access to GRP-field values</p>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-pageSizeMax' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-property-pageSizeMax' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-property-pageSizeMax' class='name expandable'>pageSizeMax</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Hard limit. ...</div><div class='long'><p>Hard limit. How many results are returned per findFirstSords/findNextSords. <code>pageSize</code> gets sanitized to this value if it is defined and greater</p>\n<p>Defaults to: <code>1000</code></p></div></div></div><div id='property-searchCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-property-searchCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-property-searchCache' class='name expandable'>searchCache</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>current idx and remaining desired results for each search ...</div><div class='long'><p>current idx and remaining desired results for each search</p>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-wildCard' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-property-wildCard' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-property-wildCard' class='name expandable'>wildCard</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Character which will be used as the wildcard character in fuzzy searches. ...</div><div class='long'><p>Character which will be used as the wildcard character in fuzzy searches.</p>\n<p>Defaults to: <code>&quot;*&quot;</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addAsDirectValueInstruction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-addAsDirectValueInstruction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-addAsDirectValueInstruction' class='name expandable'>addAsDirectValueInstruction</a>( <span class='pre'>instanceScope, instructions, target</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instanceScope</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>target</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addAsSourceTargetInstruction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-addAsSourceTargetInstruction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-addAsSourceTargetInstruction' class='name expandable'>addAsSourceTargetInstruction</a>( <span class='pre'>instructions, source, target</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>source</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>target</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addConverterKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-addConverterKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-addConverterKey' class='name expandable'>addConverterKey</a>( <span class='pre'>converterConfig, type, key, prop</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>converterConfig</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>type</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>key</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>prop</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addCriterionToQuery' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-addCriterionToQuery' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-addCriterionToQuery' class='name expandable'>addCriterionToQuery</a>( <span class='pre'>maxGroups, supplementaryFindInfo, query, criterion</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maxGroups</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>supplementaryFindInfo</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>query</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>criterion</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addDataCollectedFromIdContainer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-addDataCollectedFromIdContainer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-addDataCollectedFromIdContainer' class='name expandable'>addDataCollectedFromIdContainer</a>( <span class='pre'>idContainer, instructions, allCollectedData, ofMask</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>idContainer</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>allCollectedData</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>ofMask</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addDirectValuesToIds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-addDirectValuesToIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-addDirectValuesToIds' class='name expandable'>addDirectValuesToIds</a>( <span class='pre'>ids, instructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ids</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addDirectValuesToSords' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-addDirectValuesToSords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-addDirectValuesToSords' class='name expandable'>addDirectValuesToSords</a>( <span class='pre'>sords, instructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sords</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addFilterDefinition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-addFilterDefinition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-addFilterDefinition' class='name expandable'>addFilterDefinition</a>( <span class='pre'>instructions, filter</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>filter</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addInstructionsToCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-addInstructionsToCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-addInstructionsToCache' class='name expandable'>addInstructionsToCache</a>( <span class='pre'>cacheName, instructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cacheName</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addMb' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-addMb' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-addMb' class='name expandable'>addMb</a>( <span class='pre'>mbs, type, key</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>helpers for parseOutputDefinition ...</div><div class='long'><p>helpers for parseOutputDefinition</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mbs</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>type</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>key</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addOR' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-addOR' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-addOR' class='name expandable'>addOR</a>( <span class='pre'>query, index, length</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>query</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>index</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>length</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addOutputInstruction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-addOutputInstruction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-addOutputInstruction' class='name expandable'>addOutputInstruction</a>( <span class='pre'>multipleOptsDefined, instructions, outputInstruction, i</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>multipleOptsDefined</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>outputInstruction</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>i</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addToOptimizationCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-addToOptimizationCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-addToOptimizationCache' class='name expandable'>addToOptimizationCache</a>( <span class='pre'>cache, instructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cache</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-arrayToRegExp' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-arrayToRegExp' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-arrayToRegExp' class='name expandable'>arrayToRegExp</a>( <span class='pre'>arr, wc</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>wc</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-assignFallbackIdProp' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-assignFallbackIdProp' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-assignFallbackIdProp' class='name expandable'>assignFallbackIdProp</a>( <span class='pre'>instructions, lonelyDef</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>lonelyDef</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildFindByIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-buildFindByIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-buildFindByIndex' class='name expandable'>buildFindByIndex</a>( <span class='pre'>masks, searchfields</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>masks</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchfields</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildFindDirect' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-buildFindDirect' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-buildFindDirect' class='name expandable'>buildFindDirect</a>( <span class='pre'>masks, searchCriteria, queryOpts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>masks</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchCriteria</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>queryOpts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildFindInfoForContextTerms' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-buildFindInfoForContextTerms' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-buildFindInfoForContextTerms' class='name expandable'>buildFindInfoForContextTerms</a>( <span class='pre'>masks, searchCriteria, queryOpts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>masks</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchCriteria</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>queryOpts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildFindInfoForFindByIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-buildFindInfoForFindByIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-buildFindInfoForFindByIndex' class='name expandable'>buildFindInfoForFindByIndex</a>( <span class='pre'>masks, searchfields</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>masks</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchfields</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildFindInfoForFindDirect' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-buildFindInfoForFindDirect' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-buildFindInfoForFindDirect' class='name expandable'>buildFindInfoForFindDirect</a>( <span class='pre'>masks, searchCriteria</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>masks</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchCriteria</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildIdContainer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-buildIdContainer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-buildIdContainer' class='name expandable'>buildIdContainer</a>( <span class='pre'>inputIds</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>inputIds</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildMasksQuery' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-buildMasksQuery' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-buildMasksQuery' class='name expandable'>buildMasksQuery</a>( <span class='pre'>masks</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>masks</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildQuery' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-buildQuery' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-buildQuery' class='name expandable'>buildQuery</a>( <span class='pre'>masks, searchCriteria, queryOpts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>masks</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchCriteria</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>queryOpts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildRegEx' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-buildRegEx' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-buildRegEx' class='name expandable'>buildRegEx</a>( <span class='pre'>values</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>values</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildValueQuery' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-buildValueQuery' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-buildValueQuery' class='name expandable'>buildValueQuery</a>( <span class='pre'>key, value, tokenized</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>value</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>tokenized</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-calcFlags' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-calcFlags' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-calcFlags' class='name expandable'>calcFlags</a>( <span class='pre'>instructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-castThenAddResults' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-castThenAddResults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-castThenAddResults' class='name expandable'>castThenAddResults</a>( <span class='pre'>acc, result</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>acc</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>result</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-cleanConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-cleanConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-cleanConfig' class='name expandable'>cleanConfig</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-closeFind' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-closeFind' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-closeFind' class='name expandable'>closeFind</a>( <span class='pre'>searchId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>searchId</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-collectDataFromId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-collectDataFromId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-collectDataFromId' class='name expandable'>collectDataFromId</a>( <span class='pre'>id, instructions, mask</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>mask</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-contains' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-contains' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-contains' class='name expandable'>contains</a>( <span class='pre'>val, s</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>val</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>s</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-createObjKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-createObjKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-createObjKey' class='name expandable'>createObjKey</a>( <span class='pre'>name, value</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>helpers for search ...</div><div class='long'><p>helpers for search</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>value</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-createObjKeys' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-createObjKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-createObjKeys' class='name expandable'>createObjKeys</a>( <span class='pre'>searchfields</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>searchfields</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-createSordZ' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-createSordZ' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-createSordZ' class='name expandable'>createSordZ</a>( <span class='pre'>mbs</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mbs</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-defaultDataCollection' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-defaultDataCollection' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-defaultDataCollection' class='name expandable'>defaultDataCollection</a>( <span class='pre'>resultArr, ids, instructions, mask</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>resultArr</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>ids</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>mask</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-definesDirectValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-definesDirectValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-definesDirectValue' class='name expandable'>definesDirectValue</a>( <span class='pre'>isValidTarget, target</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>isValidTarget</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>target</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-escapeOrRemoveInvalidCharacters' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-escapeOrRemoveInvalidCharacters' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-escapeOrRemoveInvalidCharacters' class='name expandable'>escapeOrRemoveInvalidCharacters</a>( <span class='pre'>val</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>val</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-extendQueryByCustomQuery' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-extendQueryByCustomQuery' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-extendQueryByCustomQuery' class='name expandable'>extendQueryByCustomQuery</a>( <span class='pre'>query, custom</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>query</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>custom</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-extendQueryByWildCard' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-extendQueryByWildCard' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-extendQueryByWildCard' class='name expandable'>extendQueryByWildCard</a>( <span class='pre'>query</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>query</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-fastFilter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-fastFilter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-fastFilter' class='name expandable'>fastFilter</a>( <span class='pre'>sords, filter</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sords</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>filter</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-filterSords' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-filterSords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-filterSords' class='name expandable'>filterSords</a>( <span class='pre'>sords, filter</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sords</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>filter</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-finalizeCollector' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-finalizeCollector' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-finalizeCollector' class='name expandable'>finalizeCollector</a>( <span class='pre'>instructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-find' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-find' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-find' class='name expandable'>find</a>( <span class='pre'>findInfo, maxResults, pageSize, sordZ, searchId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>findInfo</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>maxResults</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>pageSize</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>sordZ</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchId</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-findAll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-findAll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-findAll' class='name expandable'>findAll</a>( <span class='pre'>findInfo, maxResults, sordZ</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>findInfo</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>maxResults</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>sordZ</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-findIds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-findIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-findIds' class='name expandable'>findIds</a>( <span class='pre'>masks, searchFields, options</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>masks</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchFields</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-formBlobsExtractor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-formBlobsExtractor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-formBlobsExtractor' class='name expandable'>formBlobsExtractor</a>( <span class='pre'>result, sord, fieldMapping, accessors</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>result</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>sord</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>fieldMapping</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>accessors</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-formatSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-formatSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-formatSord' class='name expandable'>formatSord</a>( <span class='pre'>sord, formatterConfig, configKeys, accessors, mask</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>formatterConfig</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>configKeys</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>accessors</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>mask</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-formatSordAsTemplateSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-formatSordAsTemplateSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-formatSordAsTemplateSord' class='name expandable'>formatSordAsTemplateSord</a>( <span class='pre'>sord, formatterConfig, configKeys, accessors, mask</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>formatterConfig</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>configKeys</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>accessors</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>mask</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-formatterIsRequired' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-formatterIsRequired' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-formatterIsRequired' class='name expandable'>formatterIsRequired</a>( <span class='pre'>instructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-generateInstructions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-generateInstructions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-generateInstructions' class='name expandable'>generateInstructions</a>( <span class='pre'>output, filter, options</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>output</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>filter</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-generateMbsFromOptions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-generateMbsFromOptions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-generateMbsFromOptions' class='name expandable'>generateMbsFromOptions</a>( <span class='pre'>mbs</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>helpers for finalizeCollector ...</div><div class='long'><p>helpers for finalizeCollector</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mbs</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-generateObjKeyLineMapping' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-generateObjKeyLineMapping' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-generateObjKeyLineMapping' class='name expandable'>generateObjKeyLineMapping</a>( <span class='pre'>maskName</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maskName</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getAvailableTerms' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-getAvailableTerms' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-getAvailableTerms' class='name expandable'>getAvailableTerms</a>( <span class='pre'>key, value, ignoreCase, findInfo, maxGroups</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>This is a workaround. ...</div><div class='long'><p>This is a workaround. getContextTerms does not support wildcards.\nTherefore before executing the actual search, all available\nvalues for the grouping term are collected and then filtered\nfor the defined value, which can contain a wildcard.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>value</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>ignoreCase</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>findInfo</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>maxGroups</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getCachedInstructions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-getCachedInstructions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-getCachedInstructions' class='name expandable'>getCachedInstructions</a>( <span class='pre'>cacheName, optimization</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cacheName</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>optimization</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getContextTerms' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-getContextTerms' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-getContextTerms' class='name expandable'>getContextTerms</a>( <span class='pre'>findInfo, groupingTerm, maxGroups</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>findInfo</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>groupingTerm</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>maxGroups</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getCriterionQuery' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-getCriterionQuery' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-getCriterionQuery' class='name expandable'>getCriterionQuery</a>( <span class='pre'>key, value, ignoreCase, tokenized, constantCriteriaFindInfo, maxGroups</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>value</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>ignoreCase</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>tokenized</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>constantCriteriaFindInfo</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>maxGroups</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getFindInfoBuilder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-getFindInfoBuilder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-getFindInfoBuilder' class='name expandable'>getFindInfoBuilder</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-getFindInfoForConstantSearchValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-getFindInfoForConstantSearchValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-getFindInfoForConstantSearchValues' class='name expandable'>getFindInfoForConstantSearchValues</a>( <span class='pre'>masks, searchCriteria, maxGroups</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>masks</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchCriteria</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>maxGroups</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getFromOptimizationCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-getFromOptimizationCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-getFromOptimizationCache' class='name expandable'>getFromOptimizationCache</a>( <span class='pre'>cache, id</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cache</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>id</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getFromSearchCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-getFromSearchCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-getFromSearchCache' class='name expandable'>getFromSearchCache</a>( <span class='pre'>store, searchId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchId</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getGroupingTerm' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-getGroupingTerm' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-getGroupingTerm' class='name expandable'>getGroupingTerm</a>( <span class='pre'>fuzzy</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fuzzy</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getIdsOfIds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-getIdsOfIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-getIdsOfIds' class='name expandable'>getIdsOfIds</a>( <span class='pre'>resultArr, ids, instructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>resultArr</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>ids</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getInstructionsFromCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-getInstructionsFromCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-getInstructionsFromCache' class='name expandable'>getInstructionsFromCache</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-getSearchCriteriaQuery' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-getSearchCriteriaQuery' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-getSearchCriteriaQuery' class='name expandable'>getSearchCriteriaQuery</a>( <span class='pre'>searchCriteria, maxGroups, supplementaryFindInfo</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>searchCriteria</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>maxGroups</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>supplementaryFindInfo</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-getSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-getSord' class='name expandable'>getSord</a>( <span class='pre'>objId, srdC</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>helpers for collectDataFromId ...</div><div class='long'><p>helpers for collectDataFromId</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>srdC</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-idsOf' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-idsOf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-idsOf' class='name expandable'>idsOf</a>( <span class='pre'>findResult</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>findResult</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-impureConcat' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-impureConcat' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-impureConcat' class='name expandable'>impureConcat</a>( <span class='pre'>target, source</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>source</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initSearchAndProcessingInstructions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-initSearchAndProcessingInstructions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-initSearchAndProcessingInstructions' class='name expandable'>initSearchAndProcessingInstructions</a>( <span class='pre'>outputDefinition, filter, options, result</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>outputDefinition</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>filter</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>result</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-initializeCaching' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-initializeCaching' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-initializeCaching' class='name expandable'>initializeCaching</a>( <span class='pre'>initOptimizationCache, instructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>initOptimizationCache</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-isValidSourceDefinition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-isValidSourceDefinition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-isValidSourceDefinition' class='name expandable'>isValidSourceDefinition</a>( <span class='pre'>sDef</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sDef</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-maintainSearchInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-maintainSearchInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-maintainSearchInfo' class='name expandable'>maintainSearchInfo</a>( <span class='pre'>searchInfo, findResult, maxResults</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>searchInfo</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>findResult</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>maxResults</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-mapExtractor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-mapExtractor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-mapExtractor' class='name expandable'>mapExtractor</a>( <span class='pre'>sord, mapDomain, fields</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>mapDomain</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>fields</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-mapKeysExtractor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-mapKeysExtractor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-mapKeysExtractor' class='name expandable'>mapKeysExtractor</a>( <span class='pre'>result, sord, fieldMapping, accessors</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>result</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>sord</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>fieldMapping</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>accessors</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-objKeysExtractor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-objKeysExtractor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-objKeysExtractor' class='name expandable'>objKeysExtractor</a>( <span class='pre'>result, sord, fieldMapping, _accessors, mask</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>result</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>sord</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>fieldMapping</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>_accessors</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>mask</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-optimizationIdDefined' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-optimizationIdDefined' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-optimizationIdDefined' class='name expandable'>optimizationIdDefined</a>( <span class='pre'>optimization</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>optimization</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-optimizeObjectAccessors' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-optimizeObjectAccessors' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-optimizeObjectAccessors' class='name expandable'>optimizeObjectAccessors</a>( <span class='pre'>instructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-pageFind' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-pageFind' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-pageFind' class='name expandable'>pageFind</a>( <span class='pre'>findInfo, maxResults, pageSize, sordZ, searchId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>findInfo</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>maxResults</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>pageSize</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>sordZ</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchId</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-pagingIdDefined' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-pagingIdDefined' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-pagingIdDefined' class='name expandable'>pagingIdDefined</a>( <span class='pre'>pagingId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>pagingId</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-parens' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-parens' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-parens' class='name expandable'>parens</a>( <span class='pre'>s</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>s</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-parseOutputDefinition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-parseOutputDefinition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-parseOutputDefinition' class='name expandable'>parseOutputDefinition</a>( <span class='pre'>outputDef</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>outputDef</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-parseSearchValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-parseSearchValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-parseSearchValue' class='name expandable'>parseSearchValue</a>( <span class='pre'>value</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-performSearch' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-performSearch' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-performSearch' class='name expandable'>performSearch</a>( <span class='pre'>masks, searchCriteria, options</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>masks</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchCriteria</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-prepareMask' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-prepareMask' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-prepareMask' class='name expandable'>prepareMask</a>( <span class='pre'>mask</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mask</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-prepareSearchInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-prepareSearchInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-prepareSearchInfo' class='name expandable'>prepareSearchInfo</a>( <span class='pre'>searchInfo, searchId, maxResults, pageSize</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>searchInfo</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchId</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>maxResults</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>pageSize</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-process' class='name expandable'>process</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>return</p>\n<ul><li><span class='pre'>sords</span> : String[]|Object[]<div class='sub-desc'><p>all found and formatted sords. String[] if <code>output</code> has only one property or Object[] otherwise</p>\n</div></li><li><span class='pre'>groups</span> : Object<div class='sub-desc'><p>map of the group by field values and their result counts</p>\n</div></li><li><span class='pre'>paging</span> : String<div class='sub-desc'><p>the searchId which can be again passed to this service as <code>options.paging</code> parameter to continue the search</p>\n</div></li><li><span class='pre'>optimization</span> : Number<div class='sub-desc'><p>the optimizationId which can be again passed to this service as <code>optimize</code></p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-processIdContainer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-processIdContainer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-processIdContainer' class='name expandable'>processIdContainer</a>( <span class='pre'>idContainer, instructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>idContainer</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-processIds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-processIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-processIds' class='name expandable'>processIds</a>( <span class='pre'>inputIds, instructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>inputIds</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-processResult' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-processResult' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-processResult' class='name expandable'>processResult</a>( <span class='pre'>findResult, ids</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>findResult</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>ids</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-propsToArrays' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-propsToArrays' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-propsToArrays' class='name expandable'>propsToArrays</a>( <span class='pre'>sords, props</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sords</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>props</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-reinitializeFormatterSettingsIfRequired' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-reinitializeFormatterSettingsIfRequired' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-reinitializeFormatterSettingsIfRequired' class='name expandable'>reinitializeFormatterSettingsIfRequired</a>( <span class='pre'>instructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-removeEmptyFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-removeEmptyFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-removeEmptyFields' class='name expandable'>removeEmptyFields</a>( <span class='pre'>sords, props</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sords</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>props</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-sanitizeQueryValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-sanitizeQueryValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-sanitizeQueryValue' class='name expandable'>sanitizeQueryValue</a>( <span class='pre'>val</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>val</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-searchFor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-searchFor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-searchFor' class='name expandable'>searchFor</a>( <span class='pre'>infos, searchCriteria, options, masks</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>infos</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchCriteria</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>masks</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-searchViaContextTerms' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-searchViaContextTerms' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-searchViaContextTerms' class='name expandable'>searchViaContextTerms</a>( <span class='pre'>masks, searchCriteria, options</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>masks</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchCriteria</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-searchViaIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-searchViaIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-searchViaIndex' class='name expandable'>searchViaIndex</a>( <span class='pre'>masks, searchCriteria, options</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>masks</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>searchCriteria</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-setUnchangedIdsAsResult' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-setUnchangedIdsAsResult' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-setUnchangedIdsAsResult' class='name expandable'>setUnchangedIdsAsResult</a>( <span class='pre'>resultArr, ids</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>resultArr</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>ids</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-sordKeysExtractor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-sordKeysExtractor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-sordKeysExtractor' class='name expandable'>sordKeysExtractor</a>( <span class='pre'>result, sord, fields</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>result</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>sord</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>fields</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-stringToRegExp' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-stringToRegExp' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-stringToRegExp' class='name expandable'>stringToRegExp</a>( <span class='pre'>str, wc, ignoreCase</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>wc</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>ignoreCase</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-templateSordFilter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-templateSordFilter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-templateSordFilter' class='name expandable'>templateSordFilter</a>( <span class='pre'>sords, filter</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sords</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>filter</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-updateSearchCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-updateSearchCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-updateSearchCache' class='name expandable'>updateSearchCache</a>( <span class='pre'>findResult, desiredResults</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>findResult</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>desiredResults</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-valuesWithoutWildcard' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/lib_sol.common.SordProvider.html#sol-common-SordProvider-method-valuesWithoutWildcard' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-method-valuesWithoutWildcard' class='name expandable'>valuesWithoutWildcard</a>( <span class='pre'>criterion</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>criterion</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_common_service_SordProvider' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordProvider'>sol.common.SordProvider</span><br/><a href='source/sol.common.ix.services.SordProvider.html#sol-common-SordProvider-static-method-RF_sol_common_service_SordProvider' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordProvider-static-method-RF_sol_common_service_SordProvider' class='name expandable'>RF_sol_common_service_SordProvider</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});